package ru.yandex.client.pg.config;

import java.io.File;
import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutablePgClientConfig
    extends ImmutableHttpTargetConfig
    implements PgClientConfig
{
    private final List<HttpHost> hosts;
    private final String database;
    private final String user;
    private final String password;
    private final int queueSize;
    private final int preparedStatementsCacheSize;
    private final int idleTimeout;
    private final long healthCheckInterval;
    private final File pemCertificate;

    public ImmutablePgClientConfig(final PgClientConfig config)
        throws ConfigException
    {
        super(config);
        hosts = HOSTS.validate(config.hosts());
        database = DATABASE.validate(config.database());
        user = USER.validate(config.user());
        password = PASSWORD.validate(config.password());
        queueSize = QUEUE_SIZE.validate(config.queueSize());
        preparedStatementsCacheSize = PREPARED_STATEMENTS_CACHE_SIZE.validate(
            config.preparedStatementsCacheSize());
        idleTimeout = IDLE_TIMEOUT.validate(config.idleTimeout());
        healthCheckInterval =
            HEALTH_CHECK_INTERVAL.validate(config.healthCheckInterval());
        pemCertificate = PEM_CERTIFICATE.validate(config.pemCertificate());
    }

    @Override
    public List<HttpHost> hosts() {
        return hosts;
    }

    @Override
    public String database() {
        return database;
    }

    @Override
    public String user() {
        return user;
    }

    @Override
    public String password() {
        return password;
    }

    @Override
    public int queueSize() {
        return queueSize;
    }

    @Override
    public int preparedStatementsCacheSize() {
        return preparedStatementsCacheSize;
    }

    @Override
    public int idleTimeout() {
        return idleTimeout;
    }

    @Override
    public long healthCheckInterval() {
        return healthCheckInterval;
    }

    @Override
    public File pemCertificate() {
        return pemCertificate;
    }
}

