package ru.yandex.client.pg.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.http.config.HttpTargetConfig;
import ru.yandex.http.util.HttpHostParser;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.DoubleToIntegerValidator;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.FileParser;
import ru.yandex.parser.string.InputFileValidator;
import ru.yandex.parser.string.NonEmptyCollectionValidator;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface PgClientConfig extends HttpTargetConfig {
    ParameterConfig<List<HttpHost>> HOSTS =
        new ParameterConfig<>(
            "hosts",
            new CollectionParser<>(
                NonEmptyValidator.TRIMMED.andThen(
                    HttpHostParser.INSTANCE),
                ArrayList::new),
            NonEmptyCollectionValidator.<HttpHost, List<HttpHost>>instance()
                .andThen(ArrayList::new));

    ParameterConfig<String> DATABASE =
        new ParameterConfig<>(
            "database",
            GenericFunction.identity(),
            NonEmptyValidator.TRIMMED);

    ParameterConfig<String> USER =
        new ParameterConfig<>(
            "user",
            GenericFunction.identity(),
            NonEmptyValidator.TRIMMED);

    ParameterConfig<String> PASSWORD =
        new ParameterConfig<>(
            "password",
            GenericFunction.identity(),
            NonEmptyValidator.TRIMMED);

    ParameterConfig<Integer> QUEUE_SIZE =
        new ParameterConfig<>(
            "queue-size",
            Integer::valueOf,
            PositiveValidator.instance());

    ParameterConfig<Integer> PREPARED_STATEMENTS_CACHE_SIZE =
        new ParameterConfig<>(
            "prepared-statements-cache-size",
            Integer::valueOf,
            NonNegativeValidator.instance());

    ParameterConfig<Integer> IDLE_TIMEOUT =
        new ParameterConfig<>(
            "timeout.idle",
            DurationParser.INSTANCE.andThen(DoubleToIntegerValidator.INSTANCE),
            PositiveValidator.instance());

    ParameterConfig<Long> HEALTH_CHECK_INTERVAL =
        new ParameterConfig<>(
            "health-check-interval",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            PositiveValidator.instance());

    ParameterConfig<File> PEM_CERTIFICATE =
        new ParameterConfig<>(
            "pem-certificate",
            FileParser.INSTANCE,
            new NullToDefaultFunction<>(InputFileValidator.INSTANCE),
            true);

    List<HttpHost> hosts();

    String database();

    String user();

    String password();

    int queueSize();

    int preparedStatementsCacheSize();

    int idleTimeout();

    long healthCheckInterval();

    File pemCertificate();
}

