package ru.yandex.client.pg.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class PgClientConfigBuilder
    extends AbstractPgClientConfigBuilder<PgClientConfigBuilder>
{
    public PgClientConfigBuilder() {
        super(PgClientConfigDefaults.INSTANCE);
    }

    public PgClientConfigBuilder(final PgClientConfig config) {
        super(config);
    }

    public PgClientConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, PgClientConfigDefaults.INSTANCE);
    }

    public PgClientConfigBuilder(
        final IniConfig config,
        final PgClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public PgClientConfigBuilder self() {
        return this;
    }

    public ImmutablePgClientConfig build() throws ConfigException {
        return new ImmutablePgClientConfig(this);
    }
}

