#include "common.h"

namespace NPyJson {

void PyErr(PyObject* exc, const std::string& msg) {
    PyErr_SetString(exc, msg.c_str());
    boost::python::throw_error_already_set();
}

void CheckMap(const NJson::TJsonValue& self) {
    if (!self.IsMap()) {
        PyErr(PyExc_TypeError,
              std::string{"JsonValue: expected JSON_MAP, got: "} +
              std::string{ToString(self.GetType())});
    }
}

void CheckArray(const NJson::TJsonValue& self) {
    if (!self.IsArray()) {
        PyErr(PyExc_TypeError,
              std::string{"JsonValue: expected JSON_ARRAY, got: "} +
              std::string{ToString(self.GetType())});
    }
}

void CheckIndexable(const NJson::TJsonValue& self) {
    if (!self.IsArray() && !self.IsMap()) {
        PyErr(PyExc_TypeError,
              std::string{"JsonValue: expected JSON_MAP or JSON_ARRAY, got: "} +
              std::string{ToString(self.GetType())});
    }
}

}
