#pragma once

#include <mail/library/python/json_value/include/json.h>
#include <util/string/cast.h>

#include <memory>

namespace NPyJson {

using TPyJsonValue = boost::python::class_<NJson::TJsonValue, std::shared_ptr<NJson::TJsonValue>, boost::noncopyable>;

void PyErr(PyObject* exc, const std::string& msg);
void CheckMap(const NJson::TJsonValue& self);
void CheckArray(const NJson::TJsonValue& self);
void CheckIndexable(const NJson::TJsonValue& self);

TPyJsonValue& DefIndexableIntf(TPyJsonValue&);
TPyJsonValue& DefMapIntf(TPyJsonValue&);
TPyJsonValue& DefArrayIntf(TPyJsonValue&);
TPyJsonValue& DefTypeInfo(TPyJsonValue&);
TPyJsonValue& DefTypedView(TPyJsonValue&);
TPyJsonValue& DefStrRepr(TPyJsonValue&);
TPyJsonValue& DefExtra(TPyJsonValue&);

template<typename V, typename T>
T SameTypeAs(V val, const T&) {
    return static_cast<T>(val);
}

}
