#include "common.h"

namespace {

using namespace NJson;
using namespace NPyJson;
namespace py = boost::python;

void Append(TJsonValue& self, const TJsonValue& item) {
    CheckArray(self);
    self.AppendValue(item);
}

void PyAppend(TJsonValue& self, const py::object& item) {
    Append(self, FromPyObject(item));
}

size_t Index(const TJsonValue& self, const TJsonValue& item) {
    CheckArray(self);
    size_t idx = 0;
    for (const auto& i: self.GetArray()) {
        if (item == i) {
            return idx;
        }
        ++idx;
    }
    PyErr(PyExc_ValueError, "Item is not in TJsonValue array");
    return 0;
}

size_t PyIndex(const TJsonValue& self, const py::object& item) {
    return Index(self, FromPyObject(item));
}

size_t Count(const TJsonValue& self, const TJsonValue& item) {
    CheckArray(self);
    size_t c = 0;
    for (const auto& i: self.GetArray()) {
        if (item == i) {
            ++c;
        }
    }
    return c;
}

size_t PyCount(const TJsonValue& self, const py::object& item) {
    return Count(self, FromPyObject(item));
}

void Iadd(TJsonValue& self, const TJsonValue& items) {
    CheckArray(self);
    CheckArray(items);
    for (const auto& i: items.GetArray()) {
        self.AppendValue(i);
    }
}

void PyIadd(TJsonValue& self, const py::list& items) {
    CheckArray(self);
    auto n = py::len(items);
    for (decltype(n) idx = 0; idx < n; ++idx) {
        self.AppendValue(FromPyObject(items[idx]));
    }
}

} // anonymous namespace

namespace NPyJson {

TPyJsonValue& DefArrayIntf(TPyJsonValue& c) {
    using namespace NJson;
    using namespace py;
    return c
        .def("append", PyAppend, return_self<>())
        .def("append_json_value", Append, return_self<>())
        .def("index", PyIndex)
        .def("index_json_value", Index)
        .def("count", PyCount)
        .def("count_json_value", Count)
        // TODO: extend(), insert(), pop(), remove(), reverse() and sort()

        // __iadd__: a += b
        .def("__iadd__", PyIadd, return_self<>())
        .def("__iadd__", Iadd, return_self<>());

        // TODO:
        // __imul__: a.__imul__ *= num
        // __add__:  c = a.__add__ + b
        // __radd__: c = a + b.__radd__
        // __mul__:  c = a.__mul__ * num
        // __rmul__: c = num * a.__rmul__
}

} // namespace NPyJson
