#include "common.h"

#include "json_indexable_array.h"
#include "json_indexable_map.h"

namespace {

using namespace NJson;
using namespace NPyJson;
using namespace NPyJson::NIndexableArray;
using namespace NPyJson::NIndexableMap;
namespace py = boost::python;

int Len(const TJsonValue& self) {
    CheckIndexable(self);
    if (self.IsMap()) {
        return self.GetMap().size();
    }
    if (self.IsArray()) {
        return self.GetArray().size();
    }
    return -1;
}

template<typename T>
void SetItem(TJsonValue& self, const py::object& idx, T val) {
    CheckIndexable(self);
    if (self.IsMap()) {
        SetItemMap<T>(self, idx, val);
    } else {
        SetItemArray<T>(self, idx, val);
    }
}

TJsonValue& GetItem(TJsonValue& self, const py::object& idx) {
    CheckIndexable(self);
    if (self.IsMap()) {
        return GetItemMap(self, idx);
    } else {
        return GetItemArray(self, idx);
    }
}

void DelItem(TJsonValue& self, const py::object& idx) {
    CheckIndexable(self);
    if (self.IsMap()) {
        DelItemMap(self, idx);
    } else {
        DelItemArray(self, idx);
    }
}

template<typename T>
bool Contains(const TJsonValue& self, T v) {
    CheckIndexable(self);
    if (self.IsMap()) {
        return ContainsMap<T>(self, v);
    } else {
        return ContainsArray<T>(self, v);
    }
}

} // anonymous namespace

namespace NPyJson {

TPyJsonValue& DefIndexableIntf(TPyJsonValue& c) {
    using namespace NJson;
    using namespace py;
    return c
        .def("__len__", Len)
        .def("__setitem__", SetItem<bool>, return_self<>())
        .def("__setitem__", SetItem<i64>, return_self<>())
        .def("__setitem__", SetItem<ui64>, return_self<>())
        .def("__setitem__", SetItem<double>, return_self<>())
        .def("__setitem__", SetItem<const char*>, return_self<>())
        .def("__setitem__", SetItem<const TJsonValue&>, return_self<>())
        .def("__setitem__", SetItem<const list&>, return_self<>())
        .def("__setitem__", SetItem<const dict&>, return_self<>())
        .def("__getitem__", GetItem, return_internal_reference<>())
        .def("__delitem__", DelItem, return_self<>())
        .def("__contains__", Contains<bool>)
        .def("__contains__", Contains<i64>)
        .def("__contains__", Contains<ui64>)
        .def("__contains__", Contains<double>)
        .def("__contains__", Contains<const char *>)
        .def("__contains__", Contains<const TJsonValue&>)
        .def("__contains__", Contains<const list&>)
        .def("__contains__", Contains<const dict&>);
        // TODO: iterators
        //.def("__iter__", def_iterator())
}

} // namespace NPyJson
