#pragma once
#include "common.h"

namespace NPyJson::NIndexableArray {

namespace py = boost::python;

NJson::TJsonValue& GetItemArray(NJson::TJsonValue& self, const py::object& idx);

template<typename T>
void SetItemArray(NJson::TJsonValue&, const py::object&, T);

template<>
void SetItemArray<bool>(NJson::TJsonValue& self, const py::object& idx, bool val);

template<>
void SetItemArray<i64>(NJson::TJsonValue& self, const py::object& idx, i64 val);

template<>
void SetItemArray<ui64>(NJson::TJsonValue& self, const py::object& idx, ui64 val);

template<>
void SetItemArray<double>(NJson::TJsonValue& self, const py::object& idx, double val);

template<>
void SetItemArray<const char*>(NJson::TJsonValue& self, const py::object& idx, const char* val);

template<>
void SetItemArray<const py::list&>(NJson::TJsonValue& self, const py::object& idx, const py::list& val);

template<>
void SetItemArray<const py::dict&>(NJson::TJsonValue& self, const py::object& idx, const py::dict& val);

template<>
void SetItemArray<const py::object&>(NJson::TJsonValue& self, const py::object& idx, const py::object& val);

template<>
void SetItemArray<const NJson::TJsonValue&>(NJson::TJsonValue& self, const py::object& idx, const NJson::TJsonValue& val);

void DelItemArray(NJson::TJsonValue& self, const py::object& idx);

template<typename T>
bool ContainsArray(const NJson::TJsonValue&, T);

template<>
bool ContainsArray<bool>(const NJson::TJsonValue& self, bool v);

template<>
bool ContainsArray<i64>(const NJson::TJsonValue& self, i64 v);

template<>
bool ContainsArray<ui64>(const NJson::TJsonValue& self, ui64 v);

template<>
bool ContainsArray<double>(const NJson::TJsonValue& self, double v);

template<>
bool ContainsArray<const char*>(const NJson::TJsonValue& self, const char* v);

template<>
bool ContainsArray<const NJson::TJsonValue&>(const NJson::TJsonValue& self, const NJson::TJsonValue& v);

template<>
bool ContainsArray<const py::list&>(const NJson::TJsonValue& self, const py::list& v);

template<>
bool ContainsArray<const py::dict&>(const NJson::TJsonValue& self, const py::dict& v);

} // namespace NPyJson::NIndexableArray
