#include "json_indexable_map.h"

namespace NPyJson::NIndexableMap {

using namespace NJson;
namespace py = boost::python;

TJsonValue& GetItemMap(TJsonValue& self, const py::object& idx) {
    py::extract<const char*> strIdx(idx);
    if (strIdx.check()) {
        if (self.GetMap().find(strIdx()) != self.GetMap().end()) {
            return self.GetMapSafe()[strIdx()];
        } else {
            PyErr(PyExc_KeyError, "Key not found");
        }
    } else {
        PyErr(PyExc_TypeError, "Wrong key type. Expected string.");
    }
    return const_cast<TJsonValue&>(TJsonValue::UNDEFINED);
}

template<>
void SetItemMap<const py::list&>(TJsonValue& self, const py::object& idx, const py::list& val) {
    auto json = FromPyObject(val);
    SetItemMap<const TJsonValue&>(self, idx, json);
}

template<>
void SetItemMap<const py::dict&>(TJsonValue& self, const py::object& idx, const py::dict& val) {
    auto json = FromPyObject(val);
    SetItemMap<const TJsonValue&>(self, idx, json);
}

void DelItemMap(TJsonValue& self, const py::object& idx) {
    py::extract<const char*> strIdx(idx);
    if (strIdx.check()) {
        if (self.GetMap().find(strIdx()) != self.GetMap().end()) {
            self.EraseValue(strIdx());
        } else {
            PyErr(PyExc_KeyError, "Key not found");
        }
    } else {
        PyErr(PyExc_TypeError, "Wrong index type. Expected string.");
    }
}

template<>
bool ContainsMap<const char*>(const TJsonValue& self, const char* v) {
    if (self.IsMap()) {
        for (const auto& [key, val]: self.GetMap()) {
            if (key == v) {
                return true;
            }
        }
    }
    return false;
}

template<>
bool ContainsMap<const TJsonValue&>(const TJsonValue& self, const TJsonValue& v) {
    if (v.IsString()) {
        for (const auto& [key, val]: self.GetMap()) {
            if (key == v.GetStringRobust()) {
                return true;
            }
        }
    }  else {
        PyErr(PyExc_TypeError,
              std::string{"JSonValue: expected JSON_STRING, got: "} +
              std::string{ToString(self.GetType())});
    }
    return false;
}

} // namespace NPyJson::NIndexableMap
