#pragma once

#include "common.h"

namespace NPyJson::NIndexableMap {

namespace py = boost::python;

NJson::TJsonValue& GetItemMap(NJson::TJsonValue& self, const py::object& idx);

template<typename T>
void SetItemMap(NJson::TJsonValue& self, const py::object& idx, T val) {
    py::extract<const char*> strIdx(idx);
    if (strIdx.check()) {
        self.GetMapSafe()[strIdx()] = val;
    } else {
        PyErr(PyExc_TypeError, "Wrong index type. Expected string.");
    }
}

template<>
void SetItemMap<const py::list&>(NJson::TJsonValue& self, const py::object& idx, const py::list& val);

template<>
void SetItemMap<const py::dict&>(NJson::TJsonValue& self, const py::object& idx, const py::dict& val);

void DelItemMap(NJson::TJsonValue& self, const py::object& idx);

template<typename T>
bool ContainsMap(const NJson::TJsonValue&, T) {
    return false;
}

template<>
bool ContainsMap<const char*>(const NJson::TJsonValue& self, const char* v);

template<>
bool ContainsMap<const NJson::TJsonValue&>(const NJson::TJsonValue& self, const NJson::TJsonValue& v);

} // anonymous namespace
