#include "common.h"

namespace {

using namespace NJson;
using namespace NPyJson;
namespace py = boost::python;

py::list PyKeys(const TJsonValue& self) {
    CheckMap(self);
    py::list result;
    for (const auto& [key, val]: self.GetMap()) {
        result.append(py::str(key.c_str()));
    }
    return result;
}

py::list PyValues(const TJsonValue& self) {
    CheckMap(self);
    py::list result;
    for (const auto& [key, val]: self.GetMap()) {
        result.append(ToPyObject(val));
    }
    return result;
}

TJsonValue* Keys(const TJsonValue& self) {
    CheckMap(self);
    TJsonValue* result = new TJsonValue(JSON_ARRAY);
    for (const auto& [key, val]: self.GetMap()) {
        result->AppendValue({key.c_str()});
    }
    return result;
}

TJsonValue* Values(const TJsonValue& self) {
    CheckMap(self);
    TJsonValue* result = new TJsonValue(JSON_ARRAY);
    for (const auto& [key, val]: self.GetMap()) {
        result->AppendValue(val);
    }
    return result;
}

} // anonymous namespace

namespace NPyJson {

TPyJsonValue& DefMapIntf(TPyJsonValue& c) {
    using namespace NJson;
    using namespace py;
    return c
        .def("keys", PyKeys)
        .def("keys_json_value", Keys, return_value_policy<manage_new_object>())
        .def("values", PyValues)
        .def("values_json_value", Values, return_value_policy<manage_new_object>());
}

}
