#include "common.h"

#include <library/cpp/json/json_writer.h>
#include <library/cpp/json/json_reader.h>

namespace {

using namespace NJson;
using namespace NPyJson;
namespace py = boost::python;

py::str Repr(TJsonValue& self) {
    return {WriteJson(self).data()};
}

py::str Str(TJsonValue& self) {
    return {WriteJson(self, false).data()};
}

TJsonValue* ReadFromString(std::string str) {
    auto result = std::make_unique<TJsonValue>();
    try {
        ReadJsonTree(str, true, &(*result), true);
    } catch (const TJsonException& e) {
        PyErr(PyExc_ValueError, std::string{"Could not parse string into TJsonValue\n"} + e.what());
    }
    return result.release();
}

} // anonymous namespace

namespace NPyJson {

TPyJsonValue& DefStrRepr(TPyJsonValue& c) {
    using namespace NJson;
    using namespace py;

    def("read_json_value_from_string", ReadFromString, return_value_policy<manage_new_object>());

    return c
        .def("__repr__", Repr)
        .def("__str__", Str);
}

} // namespace NPyJson
