package ru.yandex.parser.query;

public class AndQuery implements QueryAtom {
    private final QueryAtom lhs;
    private final QueryAtom rhs;

    public AndQuery(final QueryAtom lhs, final QueryAtom rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public QueryAtom lhs() {
        return lhs;
    }

    public QueryAtom rhs() {
        return rhs;
    }

    @Override
    public <T, E extends Exception> T accept(final QueryVisitor<T, E> visitor)
        throws E
    {
        return visitor.visit(this);
    }
}

