package ru.yandex.parser.query;

import java.util.Arrays;
import java.util.List;

public class FieldQuery implements QueryAtom {
    private final List<String> fields;
    private final QueryAtom query;

    public FieldQuery(final Token fieldsToken, final QueryAtom query) {
        String fields = fieldsToken.toString();
        fields = fields.substring(0, fields.length() - 1);
        this.fields = Arrays.asList(fields.split(","));
        this.query = query;
    }

    public List<String> fields() {
        return fields;
    }

    public QueryAtom query() {
        return query;
    }

    @Override
    public <T, E extends Exception> T accept(final QueryVisitor<T, E> visitor)
        throws E
    {
        return visitor.visit(this);
    }
}

