package ru.yandex.parser.query;

import java.util.function.Predicate;

public interface PredicateQueryVisitor<T, E extends Exception>
    extends QueryVisitor<Predicate<T>, E>
{
    @Override
    default Predicate<T> visit(final AndQuery query) throws E {
        return query.lhs().accept(this).and(query.rhs().accept(this));
    }

    @Override
    default Predicate<T> visit(final OrQuery query) throws E {
        return query.lhs().accept(this).or(query.rhs().accept(this));
    }

    @Override
    default Predicate<T> visit(final NotQuery query) throws E {
        return query.query().accept(this).negate();
    }
}

