package ru.yandex.parser.query;

public class QueryToken implements QueryAtom {
    private final String text;
    private final int pos;
    private final int length;

    public QueryToken(final Token token) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        String text = token.toString();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (escaped) {
                escaped = false;
                sb.append(c);
            } else if (c == '\\') {
                escaped = true;
            } else {
                sb.append(c);
            }
        }

        if (escaped) {
            sb.append('\\');
        }

        this.text = new String(sb);
        pos = token.pos();
        length = text.length();
    }

    public String text() {
        return text;
    }

    public int pos() {
        return pos;
    }

    public int length() {
        return length;
    }

    @Override
    public <T, E extends Exception> T accept(final QueryVisitor<T, E> visitor)
        throws E
    {
        return visitor.visit(this);
    }
}

