package ru.yandex.parser.query;

public interface QueryVisitor<T, E extends Exception> {
    default T visit(final QueryAtom query) throws E {
        return query.accept(this);
    }

    T visit(AndQuery query) throws E;

    T visit(OrQuery query) throws E;

    T visit(NotQuery query) throws E;

    T visit(FieldQuery query) throws E;

    T visit(QuotedQuery query) throws E;

    T visit(QueryToken query) throws E;
}

