package ru.yandex.parser.query;

import ru.yandex.parser.query.generated.Tokenizer;

public interface Token {
    enum Type implements Token {
        FIELD(true),
        TOKEN(true),
        INTEGER(true),
        DOUBLE(true),
        QUOTE(false),
        BOOST(false),
        FUZZY(false),
        LPAR(false),
        RPAR(false),
        AND(false),
        OR(false),
        NOT(false),
        WHITESPACE(false),
        EOF(false);

        private final boolean text;

        Type(final boolean text) {
            this.text = text;
        }

        public Token createToken(final Tokenizer tokenizer) {
            if (text) {
                return new TextToken(
                    this,
                    tokenizer.yytext(),
                    tokenizer.pos());
            } else {
                return this;
            }
        }

        @Override
        public Type type() {
            return this;
        }
    }

    Type type();

    default int pos() {
        return -1;
    }
}

