package ru.yandex.parser.query.generated;

import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Deque;

import ru.yandex.parser.query.Token;

%%

%class Tokenizer
%public
%buffer 1024
%yylexthrow ParseException
%function nextToken
%type Token.Type
%eofval{
    return Token.Type.EOF;
%eofval}

%char
%{
    private final Deque<Integer> states = new ArrayDeque<>();

    public void state(final int state) {
        states.push(yystate());
        yybegin(state);
    }

    public void unstate() {
        yybegin(states.pop());
    }

    public int pos() {
        return (int) yychar;
    }
%}

Integer             = 0 | [1-9] [0-9]*
Exp                 = [eE] [+-]? [0-9]+
Double              = [-]? ({Integer} | [0-9]+ "." [0-9]* | "." [0-9]+) {Exp}

SpecialChar         = [()\[\]{}:*?\^~\"\\-]
EscapedChar         = \\ ({SpecialChar} | [\s])

TokenChar           = [\S--[:)]] | {EscapedChar}
FirstTokenChar      = [\S--[:\"(-]] | {EscapedChar}
Token               = {FirstTokenChar} {TokenChar}*

FieldChar           = [\p{Alpha}\p{Digit}_-]
FirstFieldChar      = [\p{Alpha}\p{Digit}_]
FieldFirstTokenChar = [\S--[\"(-]] | {EscapedChar}
FieldTokenChar      = [\S--[)]] | {EscapedChar}
SingleField         = {FirstFieldChar} {FieldChar}*
Field               = {SingleField} ("," {SingleField})* ":"
FieldToken          = {FieldFirstTokenChar} {FieldTokenChar}*

QuotedToken         = ([\S--\"] | {EscapedChar})+
And                 = \s+ (("AND" | "И") \s+)?
Or                  = \s+ ("OR" | "ИЛИ") \s+
Not                 = (("NOT" | "НЕ") \s+ | "-")

%state QUOTED_QUERY
%state FIELD_QUERY
%state NESTED_FIELD_QUERY

%%

<YYINITIAL> {
    {Or}            {return Token.Type.OR;}
    ")"             {return Token.Type.RPAR;}

    \s+             {return Token.Type.WHITESPACE;}
    {And}           {return Token.Type.AND;}

    {Not}           {return Token.Type.NOT;}
    "("             {return Token.Type.LPAR;}
    \"              {return Token.Type.QUOTE;}
    {Field}         {return Token.Type.FIELD;}
    {Token}	    {return Token.Type.TOKEN;}
}

<QUOTED_QUERY> {
    \"              {return Token.Type.QUOTE;}
    {QuotedToken}   {return Token.Type.TOKEN;}
    .               {return Token.Type.WHITESPACE;}
}

<FIELD_QUERY> {
    {Not}           {return Token.Type.NOT;}
    "("             {return Token.Type.LPAR;}
    \"              {return Token.Type.QUOTE;}
    {FieldToken}    {return Token.Type.TOKEN;}
    \s              {break;}
}

<NESTED_FIELD_QUERY> {
    {Or}            {return Token.Type.OR;}
    ")"             {return Token.Type.RPAR;}

    \s+             {return Token.Type.WHITESPACE;}
    {And}           {return Token.Type.AND;}

    {Not}           {return Token.Type.NOT;}
    "("             {return Token.Type.LPAR;}
    \"              {return Token.Type.QUOTE;}
    {FieldToken}    {return Token.Type.TOKEN;}
}

[^]                 {
                        throw new ParseException(
                            "Could not match text '" + yytext()
                            + "' at pos: " + pos(),
                            pos());
                    }

