#pragma once

#include <openssl/ssl.h>

#include <string>
#include <optional>

namespace NReceived {

struct TReceived {
    std::string Date;  // RFC 822 compliant date
    std::string LocalHost;
    std::string SessionId;
    std::string Protocol = "SMTP";
    std::string HeloHost;
    std::string RemoteHost;
    std::string RemoteIp;
    std::string ClusterName;
    std::string Recipient;
    SSL* Ssl = nullptr;
};

std::string BuildReceivedHeaderValue(const TReceived& received);

std::string BuildReceivedHeader(const TReceived& received);

std::pair<std::string, std::string> BuildReceivedPair(const TReceived& received);

}  // namespace NReceived
