package ru.yandex.detect.rfc822;

import java.io.IOException;
import java.io.InputStream;

import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public enum Rfc822Detector implements Detector {
    INSTANCE;

    %% machine Rfc822Detector;
    %% alphtype byte;
    %% write data;

    private static final int BUFFER_SIZE = 8192;
    private static final MediaType MESSAGE_RFC822 =
        new MediaType("message", "rfc822");

    @SuppressWarnings("fallthrough")
    private static boolean isRfc822(final byte[] data, final int pe) {
        int p = 0;
        int cs;
        %% write init;
        boolean date = false;
        boolean source = false;
        boolean destination = false;
        %%{
            action date {
                date = true;
            }

            action source {
                source = true;
            }

            action destination {
                destination = true;
            }

            action done {
                if (true) {
                    return date && source && destination;
                }
            }

            action error {
                if (true) {
                    return false;
                }
            }

            crlf = "\r"? "\n";
            lws = crlf? [ \t]+;
            date = "date"i @date;
            source = "from"i @source;
            destination = ("resent-"i)? ("to"i | "cc"i | "bcc"i) @destination;
            field_name = date | source | destination | (ascii - cntrl - [ :])+;
            field_body_contents = (ascii - cntrl)*;
            field_body = field_body_contents (lws field_body_contents)*;
            field = field_name ":" field_body crlf;
            main := field+ crlf @done %err(error);
            write exec;
        }%%
        return false;
    }

    @Override
    public MediaType detect(final InputStream in, final Metadata metadata)
        throws IOException
    {
        byte[] buf = new byte[BUFFER_SIZE];
        int len = 0;
        in.mark(buf.length);
        try {
            while (len < buf.length) {
                int read = in.read(buf, len, buf.length - len);
                if (read == -1) {
                    break;
                } else {
                    len += read;
                }
            }
            if (isRfc822(buf, len)) {
                return MESSAGE_RFC822;
            } else {
                return MediaType.OCTET_STREAM;
            }
        } finally {
            in.reset();
        }
    }
}

