package ru.yandex.cache;

import java.io.Closeable;

public abstract class CacheEntry implements Closeable {
    private int compressedSize;
    private int decompressedSize;

    protected CacheEntry(
        final int compressedSize,
        final int decompressedSize)
    {
        this.compressedSize = compressedSize;
        this.decompressedSize = decompressedSize;
    }

    public int compressedSize() {
        return compressedSize;
    }

    public int decompressedSize() {
        return decompressedSize;
    }

    public abstract long address();
}
