package ru.yandex.cache;

import java.io.Closeable;

public abstract class CopyEntry implements Closeable {
    protected String key;
    protected int compressedSize;
    protected int decompressedSize;
    protected int accessFreq;

    protected CopyEntry(
        final String key,
        final int compressedSize,
        final int decompressedSize,
        final int accessFreq)
    {
        this.key = key;
        this.compressedSize = compressedSize;
        this.decompressedSize = decompressedSize;
        this.accessFreq = accessFreq;
    }

    public String key() {
        return key;
    }

    public int compressedSize() {
        return compressedSize;
    }

    public int decompressedSize() {
        return decompressedSize;
    }

    public int accessFreq() {
        return accessFreq;
    }

    public abstract byte[] data();

    public abstract long address();
}
