package ru.yandex.cache;

import java.io.Closeable;
import java.io.IOException;

public interface DBCache extends Closeable, CacheInfoProvider {
    void flush();

    //CSOFF: ParameterNumber
    void put(
        final String key,
        final long address,
        final int len,
        final int decompressedLen,
        final int accessFreq,
        final boolean sync)
        throws IOException;
    //CSON: ParameterNumber

    CacheEntry get(final String key, final boolean update) throws IOException;

    CopyEntry getOne() throws IOException;

    void update(final String key, final boolean sync)
        throws IOException;

    void remove(final String key, final boolean sync)
        throws IOException;

    void removePrefix(final String key, final boolean sync)
        throws IOException;

    void deleteTop(final int count) throws IOException;

    long cacheSize() throws IOException;

    String[] uniqFiles() throws IOException;
}
