package ru.yandex.cache.sqlite;

import ru.yandex.cache.CacheEntry;

public final class SqliteCacheEntry extends CacheEntry {
    private final long address;

    public SqliteCacheEntry(
        final int compressedSize,
        final int decompressedSize,
        final long address)
    {
        super(compressedSize, decompressedSize);
        this.address = address;
    }

    @Override
    public long address() {
        return address;
    }

    @Override
    public void close() {
        if (address != 0) {
            SqliteCache.freeBlob(address);
        }
    }
}
