package ru.yandex.cache.sqlite;

import ru.yandex.cache.CopyEntry;
import ru.yandex.unsafe.NativeMemory2;

public class SqliteCopyEntry extends CopyEntry {
    private long address;

    //CSOFF: ParameterNumber
    public SqliteCopyEntry(
        final String key,
        final int compressedSize,
        final int decompressedSize,
        final int accessFreq,
        final long address)
    {
        super(key, compressedSize, decompressedSize, accessFreq);
        this.address = address;
    }
    //CSON: ParameterNumber

    @Override
    public long address() {
        return address;
    }

    @Override
    public byte[] data() {
        byte[] data = new byte[compressedSize];
        NativeMemory2.unboxedRead(
            address,
            data,
            0,
            compressedSize);
        return data;
    }

    @Override
    public void close() {
        if (address != 0) {
            SqliteCache.freeBlob(address);
        }
    }
}
