package ru.yandex.util.storage;

import java.nio.charset.Charset;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.IntegerMemorySizeParser;

public abstract class AbstractDataExtractorConfigBuilder
    <T extends AbstractDataExtractorConfigBuilder<T>>
    implements DataExtractorConfig
{
    private int maxInputLength;
    private boolean truncateLongInput;
    private Charset charset;

    protected AbstractDataExtractorConfigBuilder(
        final DataExtractorConfig config)
    {
        maxInputLength = config.maxInputLength();
        truncateLongInput = config.truncateLongInput();
        charset = config.charset();
    }

    protected AbstractDataExtractorConfigBuilder(
        final IniConfig config,
        final DataExtractorConfig defaults)
        throws ConfigException
    {
        maxInputLength = config.get(
            "max-input-length",
            defaults.maxInputLength(),
            IntegerMemorySizeParser.INSTANCE);
        truncateLongInput = config.getBoolean(
            "truncate-long-input",
            defaults.truncateLongInput());
        charset = config.getCharset("charset", defaults.charset());
    }

    @Override
    public int maxInputLength() {
        return maxInputLength;
    }

    public T maxInputLength(final int maxInputLength) {
        this.maxInputLength = maxInputLength;
        return self();
    }

    @Override
    public boolean truncateLongInput() {
        return truncateLongInput;
    }

    public T truncateLongInput(final boolean truncateLongInput) {
        this.truncateLongInput = truncateLongInput;
        return self();
    }

    @Override
    public Charset charset() {
        return charset;
    }

    public T charset(final Charset charset) {
        this.charset = charset;
        return self();
    }

    protected abstract T self();
}

