package ru.yandex.util.storage;

import java.io.IOException;
import java.io.InputStream;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;

import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.UnsupportedMediaTypeException;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.io.IOStreamUtils;

public enum C2CDataExtractor implements DataExtractor {
    INSTANCE;

    public static final String METAINFO = "Metainfo";

    @Override
    public StorageData extractData(
        final InputStream in,
        final long contentLength,
        final ImmutableDataExtractorConfig config)
        throws IOException
    {
        DecodableByteArrayOutputStream out =
            CharsetUtils.prepareDecodable(contentLength);
        IOStreamUtils.copy(in, out);
        return new StorageData(null, out);
    }

    @Override
    public StorageData extractData(
        final HttpResponse response,
        final ImmutableDataExtractorConfig config)
        throws HttpException, IOException
    {
        Header metainfoHeader = response.getFirstHeader(METAINFO);
        ContentType contentType;
        if (metainfoHeader == null) {
            contentType = null;
        } else {
            String metainfo = metainfoHeader.getValue();
            if (metainfo == null) {
                contentType = null;
            } else {
                try {
                    contentType = ContentType.parse(metainfo);
                } catch (RuntimeException e) {
                    throw new UnsupportedMediaTypeException(
                        "Failed to parse content type: " + metainfo,
                        e);
                }
            }
        }
        return new StorageData(
            contentType,
            CharsetUtils.toDecodable(response.getEntity()));
    }
}

