package ru.yandex.util.storage;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class DataExtractorConfigBuilder
    extends AbstractDataExtractorConfigBuilder<DataExtractorConfigBuilder>
{
    public DataExtractorConfigBuilder() {
        super(DataExtractorConfigDefaults.INSTANCE);
    }

    public DataExtractorConfigBuilder(final DataExtractorConfig config) {
        super(config);
    }

    public DataExtractorConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, DataExtractorConfigDefaults.INSTANCE);
    }

    public DataExtractorConfigBuilder(
        final IniConfig config,
        final DataExtractorConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public DataExtractorConfigBuilder self() {
        return this;
    }

    public ImmutableDataExtractorConfig build() {
        return new ImmutableDataExtractorConfig(this);
    }
}

