package ru.yandex.util.storage;

import java.nio.charset.Charset;

public class ImmutableDataExtractorConfig implements DataExtractorConfig {
    private final int maxInputLength;
    private final boolean truncateLongInput;
    private final Charset charset;

    public ImmutableDataExtractorConfig(final DataExtractorConfig config) {
        maxInputLength = config.maxInputLength();
        truncateLongInput = config.truncateLongInput();
        charset = config.charset();
    }

    @Override
    public int maxInputLength() {
        return maxInputLength;
    }

    @Override
    public boolean truncateLongInput() {
        return truncateLongInput;
    }

    @Override
    public Charset charset() {
        return charset;
    }
}

