package ru.yandex.util.storage;

import java.util.Objects;
import java.util.function.BiFunction;

import org.apache.http.entity.ContentType;

import ru.yandex.function.AbstractStringBuilderable;
import ru.yandex.function.Processable;
import ru.yandex.function.Processor;
import ru.yandex.function.VoidProcessor;

public class StorageData extends AbstractStringBuilderable {
    private final ContentType contentType;
    private final Processable<byte[]> data;

    public StorageData(
        final ContentType contentType,
        final Processable<byte[]> data)
    {
        this.contentType = contentType;
        this.data = data;
    }

    public ContentType contentType() {
        return contentType;
    }

    public String metainfo() {
        return Objects.toString(contentType, null);
    }

    public <E extends Exception> void processWith(
        final VoidProcessor<byte[], E> processor)
        throws E
    {
        data.processWith(processor);
    }

    public <R, E extends Exception> R processWith(
        final Processor<byte[], R, E> processor)
        throws E
    {
        return data.processWith(processor);
    }

    public <E extends Exception> String processWith(
        final String uri,
        final BiFunction<
            String,
            String,
            Processor<byte[], String, E>>
        processorSupplier)
        throws E
    {
        return data.processWith(processorSupplier.apply(uri, metainfo()));
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append('[');
        sb.append(data.length());
        sb.append(" bytes");
        if (contentType != null) {
            sb.append(" of '");
            sb.append(contentType.toString());
            sb.append('\'');
        }
        sb.append(']');
    }
}

