package ru.yandex.tikaite.config;

import java.util.Set;

import ru.yandex.jniwrapper.AbstractJniWrapperConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractFieldsFilterConfigBuilder
    <T extends AbstractFieldsFilterConfigBuilder<T>>
    extends AbstractJniWrapperConfigBuilder<T>
    implements FieldsFilterConfig
{
    private Set<String> filterFields;
    private Set<String> bypassFields;

    protected AbstractFieldsFilterConfigBuilder(final FieldsFilterConfig config) {
        super(config);
        filterFields(config.filterFields());
        bypassFields(config.bypassFields());
    }

    protected AbstractFieldsFilterConfigBuilder(
        final IniConfig config,
        final FieldsFilterConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        filterFields = FILTER_FIELDS.extract(config, defaults.filterFields());
        bypassFields = BYPASS_FIELDS.extract(config, defaults.bypassFields());
    }

    @Override
    public Set<String> filterFields() {
        return filterFields;
    }

    public T filterFields(final Set<String> filterFields) {
        this.filterFields = filterFields;
        return self();
    }

    @Override
    public Set<String> bypassFields() {
        return bypassFields;
    }

    public T bypassFields(final Set<String> bypassFields) {
        this.bypassFields = bypassFields;
        return self();
    }
}

