package ru.yandex.tikaite.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractTikaiteConfigBuilder
    <T extends AbstractTikaiteConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements TikaiteConfig
{
    private HttpHostConfigBuilder storageConfig;
    private String uriSuffix;
    private TextExtractorConfigBuilder textExtractorConfig;

    protected AbstractTikaiteConfigBuilder(final TikaiteConfig config) {
        super(config);
        storageConfig(config.storageConfig());
        uriSuffix(config.uriSuffix());
        textExtractorConfig(config.textExtractorConfig());
    }

    protected AbstractTikaiteConfigBuilder(
        final IniConfig config,
        final TikaiteConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig storageConfig = config.section("storage");
        this.storageConfig =
            new HttpHostConfigBuilder(storageConfig, defaults.storageConfig());
        uriSuffix =
            storageConfig.getString("uri-suffix", defaults.uriSuffix());
        textExtractorConfig = new TextExtractorConfigBuilder(
            config.section("extractor"),
            defaults.textExtractorConfig());
    }

    @Override
    public HttpHostConfigBuilder storageConfig() {
        return storageConfig;
    }

    public T storageConfig(final HttpHostConfig storageConfig) {
        this.storageConfig = new HttpHostConfigBuilder(storageConfig);
        return self();
    }

    @Override
    public String uriSuffix() {
        return uriSuffix;
    }

    public T uriSuffix(final String uriSuffix) {
        this.uriSuffix = uriSuffix;
        return self();
    }

    @Override
    public TextExtractorConfigBuilder textExtractorConfig() {
        return textExtractorConfig;
    }

    public T textExtractorConfig(
        final TextExtractorConfig textExtractorConfig)
    {
        this.textExtractorConfig =
            new TextExtractorConfigBuilder(textExtractorConfig);
        return self();
    }
}

