package ru.yandex.tikaite.config;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.function.GenericFunction;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface FieldsFilterConfig extends JniWrapperConfig {
    ParameterConfig<Set<String>> FILTER_FIELDS = new ParameterConfig<>(
        "filter-fields",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, HashSet::new),
        GenericFunction.identity());
    ParameterConfig<Set<String>> BYPASS_FIELDS = new ParameterConfig<>(
        "bypass-fields",
        new CollectionParser<>(NonEmptyValidator.TRIMMED, HashSet::new),
        GenericFunction.identity());

    Set<String> filterFields();

    Set<String> bypassFields();
}

