package ru.yandex.tikaite.config;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.collection.CollectionCompactor;
import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableFieldsFilterConfig
    extends ImmutableJniWrapperConfig
    implements FieldsFilterConfig
{
    private final Set<String> filterFields;
    private final Set<String> bypassFields;

    public ImmutableFieldsFilterConfig(final FieldsFilterConfig config)
        throws ConfigException
    {
        super(config);
        filterFields = CollectionCompactor.compact(
            new HashSet<>(FILTER_FIELDS.validate(config.filterFields())));
        bypassFields = CollectionCompactor.compact(
            new HashSet<>(BYPASS_FIELDS.validate(config.bypassFields())));
    }

    @Override
    public Set<String> filterFields() {
        return filterFields;
    }

    @Override
    public Set<String> bypassFields() {
        return bypassFields;
    }
}

