package ru.yandex.tikaite.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableTikaiteConfig
    extends ImmutableHttpProxyConfig
    implements TikaiteConfig
{
    private final ImmutableHttpHostConfig storageConfig;
    private final String uriSuffix;
    private final ImmutableTextExtractorConfig textExtractorConfig;

    public ImmutableTikaiteConfig(final TikaiteConfig config)
        throws ConfigException
    {
        super(config);
        storageConfig = new ImmutableHttpHostConfig(config.storageConfig());
        uriSuffix = config.uriSuffix();
        textExtractorConfig =
            new ImmutableTextExtractorConfig(config.textExtractorConfig());
    }

    @Override
    public ImmutableHttpHostConfig storageConfig() {
        return storageConfig;
    }

    @Override
    public String uriSuffix() {
        return uriSuffix;
    }

    @Override
    public ImmutableTextExtractorConfig textExtractorConfig() {
        return textExtractorConfig;
    }
}

