package ru.yandex.tikaite.config;

import java.util.Set;

import ru.yandex.parser.config.SectionConfig;
import ru.yandex.parser.mail.received.ImmutableReceivedChainParserConfig;
import ru.yandex.parser.mail.received.ReceivedChainParserConfig;
import ru.yandex.parser.mail.received.ReceivedChainParserConfigBuilder;
import ru.yandex.sanitizer2.config.SanitizingConfig;

public interface TextExtractorConfig {
    SectionConfig<
        ReceivedChainParserConfig,
        ImmutableReceivedChainParserConfig,
        ReceivedChainParserConfigBuilder>
        RECEIVED_CHAIN_PARSER = new SectionConfig<>(
            "received-chain-parser",
            ReceivedChainParserConfigBuilder::new,
            ImmutableReceivedChainParserConfig::new);

    long tmpFileLimit();

    long memoryLimit();

    Set<Integer> noXurlsTypes();

    int diskLengthLimit();

    int mailLengthLimit();

    int textLengthLimit();

    int headersLengthLimit();

    int headerLengthLimit();

    int maxHidDepth();

    int maxParts();

    int maxPartLength();

    // Sanitizing config for mimeparser. Used to create Sherlock input.
    SanitizingConfig sanitizingConfig();

    int maxSanitizingLength();

    FieldsFilterConfig fieldsFilterConfig();

    ReceivedChainParserConfig receivedChainParserConfig();
}

