package ru.yandex.tikaite.config;

import java.util.Collections;
import java.util.Set;

import ru.yandex.parser.mail.received.ReceivedChainParserConfig;
import ru.yandex.parser.mail.received.ReceivedChainParserConfigDefaults;
import ru.yandex.sanitizer2.config.SanitizingConfig;

public class TextExtractorConfigDefaults implements TextExtractorConfig {
    public static final TextExtractorConfigDefaults INSTANCE =
        new TextExtractorConfigDefaults();

    private static final long DEFAULT_TMP_FILE_LIMIT = 25000000L;
    private static final long DEFAULT_MEMORY_LIMIT = 1000000L;

    protected TextExtractorConfigDefaults() {
    }

    @Override
    public long tmpFileLimit() {
        return DEFAULT_TMP_FILE_LIMIT;
    }

    @Override
    public long memoryLimit() {
        return DEFAULT_MEMORY_LIMIT;
    }

    @Override
    public Set<Integer> noXurlsTypes() {
        return Collections.emptySet();
    }

    @Override
    public int diskLengthLimit() {
        return -1;
    }

    @Override
    public int mailLengthLimit() {
        return -1;
    }

    @Override
    public int textLengthLimit() {
        return -1;
    }

    @Override
    public int headersLengthLimit() {
        return -1;
    }

    @Override
    public int headerLengthLimit() {
        return -1;
    }

    @Override
    public int maxHidDepth() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int maxParts() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int maxPartLength() {
        return -1;
    }

    @Override
    public SanitizingConfig sanitizingConfig() {
        return null;
    }

    @Override
    public int maxSanitizingLength() {
        return -1;
    }

    @Override
    public FieldsFilterConfig fieldsFilterConfig() {
        return null;
    }

    @Override
    public ReceivedChainParserConfig receivedChainParserConfig() {
        return ReceivedChainParserConfigDefaults.INSTANCE;
    }
}

