package ru.yandex.tikaite.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class TikaiteConfigBuilder
    extends AbstractTikaiteConfigBuilder<TikaiteConfigBuilder>
{
    public TikaiteConfigBuilder() {
        super(TikaiteConfigDefaults.INSTANCE);
    }

    public TikaiteConfigBuilder(final TikaiteConfig config) {
        super(config);
    }

    public TikaiteConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, TikaiteConfigDefaults.INSTANCE);
    }

    public TikaiteConfigBuilder(
        final IniConfig config,
        final TikaiteConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public TikaiteConfigBuilder self() {
        return this;
    }

    public ImmutableTikaiteConfig build() throws ConfigException {
        return new ImmutableTikaiteConfig(this);
    }
}

