package ru.yandex.tikaite.detect;

import java.io.IOException;
import java.io.InputStream;

import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;

import ru.yandex.tikaite.util.TextExtractor;

public enum DmarcDetector implements Detector {
    INSTANCE;

    public static final MediaType DMARC = MediaType.application("x-dmarc-rua");

    @SuppressWarnings("ImmutableEnumChecker")
    private final MimeTypes mimeTypes;

    DmarcDetector() {
        try (InputStream dmarcMimetypes =
                TextExtractor.class.getResourceAsStream(
                    "dmarc-mimetypes.xml"))
        {
            mimeTypes = MimeTypesFactory.create(dmarcMimetypes);
        } catch (IOException | MimeTypeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MediaType detect(final InputStream in, final Metadata metadata)
        throws IOException
    {
        MediaType mediaType = mimeTypes.detect(in, metadata);
        if (mediaType.equals(DMARC)) {
            return DMARC;
        } else {
            return MediaType.OCTET_STREAM;
        }
    }
}

