package ru.yandex.tikaite.detect;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;

import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public enum MetadataExtractorDetector implements Detector {
    INSTANCE;

    @SuppressWarnings("ImmutableEnumChecker")
    private final Map<FileType, MediaType> map = new EnumMap<>(FileType.class);

    MetadataExtractorDetector() {
        for (FileType fileType: FileType.values()) {
            String mimeType = fileType.getMimeType();
            MediaType mediaType;
            if (mimeType != null && mimeType.startsWith("image/")) {
                mediaType = MediaType.parse(mimeType);
            } else {
                mediaType = MediaType.OCTET_STREAM;
            }
            map.put(fileType, mediaType);
        }
    }

    @Override
    public MediaType detect(final InputStream in, final Metadata metadata)
        throws IOException
    {
        if (in.markSupported()) {
            return map.get(FileTypeDetector.detectFileType(in));
        }
        return MediaType.OCTET_STREAM;
    }
}

