package ru.yandex.tikaite.mimeparser;

import java.io.IOException;
import java.io.InputStream;

import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;

public class BadHandler implements ContentHandler {
    public void fail(final Object... params) throws MimeException {
        throw new MimeException("Not implemented");
    }

    @Override
    public void body(final BodyDescriptor bd, final InputStream is)
        throws IOException, MimeException
    {
        fail(bd, is);
    }

    @Override
    public void endBodyPart() throws MimeException {
        fail();
    }

    @Override
    public void endHeader() throws MimeException {
        fail();
    }

    @Override
    public void endMessage() throws MimeException {
        fail();
    }

    @Override
    public void endMultipart() throws MimeException {
        fail();
    }

    @Override
    public void epilogue(final InputStream is)
        throws IOException, MimeException
    {
        fail(is);
    }

    @Override
    public void field(final Field field) throws MimeException {
        fail(field);
    }

    @Override
    public void preamble(final InputStream is)
        throws IOException, MimeException
    {
        fail(is);
    }

    @Override
    public void raw(final InputStream is) throws IOException, MimeException {
        fail(is);
    }

    @Override
    public void startBodyPart() throws MimeException {
        fail();
    }

    @Override
    public void startHeader() throws MimeException {
        fail();
    }

    @Override
    public void startMessage() throws MimeException {
        fail();
    }

    @Override
    public void startMultipart(final BodyDescriptor bd) throws MimeException {
        fail(bd);
    }
}

