package ru.yandex.tikaite.mimeparser;

import java.io.IOException;
import java.io.InputStream;

import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;

import ru.yandex.search.document.mail.MailMetaInfo;

public class EmptyMessageHandler extends ManagedHandler {
    protected final MailMetaInfo meta;

    public EmptyMessageHandler(final MailMetaInfo meta) {
        this.meta = meta;
    }

    @Override
    public void startMessage() throws MimeException {
    }

    @Override
    public void endMessage() throws MimeException {
    }

    @Override
    public void startHeader() throws MimeException {
    }

    @Override
    public void endHeader() throws MimeException {
    }

    @Override
    public void field(final Field field) {
        meta.add(field);
    }

    @Override
    public void body(final BodyDescriptor bd, final InputStream is)
        throws IOException, MimeException
    {
        is.close();
    }
}

