package ru.yandex.tikaite.mimeparser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;

import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;

public class HandlerManager implements ContentHandler {
    private final ArrayDeque<ContentHandler> handlers =
        new ArrayDeque<ContentHandler>();

    public void push(final ManagedHandler handler) {
        handler.setManager(this);
        handlers.push(handler);
    }

    public void pop() {
        handlers.pop();
    }

    @Override
    public void body(final BodyDescriptor bd, final InputStream is)
        throws IOException, MimeException
    {
        handlers.peek().body(bd, is);
    }

    @Override
    public void endBodyPart() throws MimeException {
        handlers.peek().endBodyPart();
    }

    @Override
    public void endHeader() throws MimeException {
        handlers.peek().endHeader();
    }

    @Override
    public void endMessage() throws MimeException {
        handlers.peek().endMessage();
    }

    @Override
    public void endMultipart() throws MimeException {
        handlers.peek().endMultipart();
    }

    @Override
    public void epilogue(final InputStream is)
        throws IOException, MimeException
    {
        handlers.peek().epilogue(is);
    }

    @Override
    public void field(final Field field) throws MimeException {
        handlers.peek().field(field);
    }

    @Override
    public void preamble(final InputStream is)
        throws IOException, MimeException
    {
        handlers.peek().preamble(is);
    }

    @Override
    public void raw(final InputStream is) throws IOException, MimeException {
        handlers.peek().raw(is);
    }

    @Override
    public void startBodyPart() throws MimeException {
        handlers.peek().startBodyPart();
    }

    @Override
    public void startHeader() throws MimeException {
        handlers.peek().startHeader();
    }

    @Override
    public void startMessage() throws MimeException {
        handlers.peek().startMessage();
    }

    @Override
    public void startMultipart(final BodyDescriptor bd) throws MimeException {
        handlers.peek().startMultipart(bd);
    }
}

