package ru.yandex.tikaite.mimeparser;

import java.io.IOException;
import java.util.Map;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.search.document.DocumentFieldsFilter;
import ru.yandex.search.document.JsonDocument;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.tikaite.util.TextExtractOptions;

public class JsonDocumentCollector implements DocumentCollector {
    private final JsonWriterBase writer;
    private final DocumentFieldsFilter fieldsFilter;
    private final String fieldsFilterOptions;
    private boolean open = true;

    public JsonDocumentCollector(
        final JsonWriterBase writer,
        final DocumentFieldsFilter fieldsFilter,
        final String fieldsFilterOptions,
        final MailMetaInfo meta)
        throws IOException
    {
        this.writer = writer;
        this.fieldsFilter = fieldsFilter;
        this.fieldsFilterOptions = fieldsFilterOptions;
        writer.startObject();
        for (Map.Entry<String, String> entry: meta.fields().entrySet()) {
            writer.key(entry.getKey());
            writer.value(entry.getValue());
        }
        writer.key("docs");
        writer.startArray();
    }

    @Override
    public void close() throws IOException {
        if (open) {
            open = false;
            writer.endArray();
            writer.endObject();
            writer.close();
        }
    }

    @Override
    public MailDocument createDocument(
        final MailMetaInfo meta,
        final String hid,
        final TextExtractOptions options)
        throws IOException
    {
        return new MailDocument(
            new JsonDocument(writer, fieldsFilter, fieldsFilterOptions),
            meta,
            options);
    }
}

