package ru.yandex.tikaite.mimeparser;

import java.io.IOException;

import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.search.document.DocumentFieldsFilter;
import ru.yandex.search.document.mail.MailMetaInfo;

public class JsonDocumentCollectorFactory
    implements DocumentCollectorFactory
{
    private final JsonWriterBase writer;
    private final DocumentFieldsFilter fieldsFilter;
    private final String fieldsFilterOptions;

    public JsonDocumentCollectorFactory(
        final JsonWriterBase writer,
        final DocumentFieldsFilter fieldsFilter,
        final String fieldsFilterOptions)
    {
        this.writer = writer;
        this.fieldsFilter = fieldsFilter;
        this.fieldsFilterOptions = fieldsFilterOptions;
    }

    @Override
    public DocumentCollector create(final MailMetaInfo meta)
        throws IOException
    {
        return new JsonDocumentCollector(
            writer,
            fieldsFilter,
            fieldsFilterOptions,
            meta);
    }
}

