package ru.yandex.tikaite.mimeparser;

import java.io.IOException;
import java.util.Map;

import ru.yandex.http.util.server.HttpServerConfigBuilder;
import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.tikaite.util.CommonFields;
import ru.yandex.tikaite.util.TextExtractOptions;

public class MailDocumentCollector implements DocumentCollector {
    private final DocumentCollector documentCollector;

    public MailDocumentCollector(final DocumentCollector documentCollector) {
        this.documentCollector = documentCollector;
    }

    @Override
    public void close() throws IOException {
        documentCollector.close();
    }

    @Override
    public MailDocument createDocument(
        final MailMetaInfo meta,
        final String hid,
        final TextExtractOptions options)
        throws IOException
    {
        MailDocument document =
            documentCollector.createDocument(meta, hid, options);
        for (Map.Entry<String, String> entry: meta.toMap().entrySet()) {
            document.addField(entry.getKey(), entry.getValue());
        }
        document.addField(MailMetaInfo.HID, hid);
        String url = meta.url(hid);
        if (url != null) {
            document.addField(MailMetaInfo.URL, url);
        }
        document.addField(
            CommonFields.BUILT_DATE,
            HttpServerConfigBuilder.BUILT_DATE);
        return document;
    }
}

