package ru.yandex.tikaite.mimeparser;

import java.io.IOException;

import ru.yandex.search.document.mail.MailMetaInfo;

public class MailDocumentCollectorFactory
    implements DocumentCollectorFactory
{
    private final DocumentCollectorFactory documentCollectorFactory;

    public MailDocumentCollectorFactory(
        final DocumentCollectorFactory documentCollectorFactory)
    {
        this.documentCollectorFactory = documentCollectorFactory;
    }

    @Override
    public DocumentCollector create(final MailMetaInfo meta)
        throws IOException
    {
        return new MailDocumentCollector(
            documentCollectorFactory.create(meta));
    }
}


