package ru.yandex.tikaite.mimeparser;

import java.io.IOException;
import java.io.InputStream;

import org.apache.james.mime4j.MimeException;

import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.tikaite.util.TextExtractOptions;

public class MultipartHandler extends MessageHandler {
    private final DocumentCollector collector;
    private boolean first = true;

    public MultipartHandler(
        final DocumentCollector collector,
        final MailMetaInfo meta,
        final TextExtractOptions options)
    {
        super(meta, options);
        this.collector = collector;
    }

    @Override
    protected DocumentCollector collector() {
        return collector;
    }

    @Override
    public void preamble(final InputStream is) throws IOException {
        is.close();
    }

    @Override
    public void epilogue(final InputStream is) throws IOException {
        is.close();
    }

    @Override
    public void endMultipart() throws MimeException {
        manager.pop();
        if (!first) {
            meta.counter().popPart();
        }
    }

    @Override
    public void startBodyPart() {
        manager.push(new BodyPartHandler(collector, meta, options));
        if (first) {
            first = false;
        } else {
            meta.counter().popPart();
        }
        meta.counter().createPart();
    }
}

