package ru.yandex.tikaite.mimeparser;

import org.apache.james.mime4j.MimeException;

import ru.yandex.search.document.mail.MailMetaInfo;
import ru.yandex.tikaite.util.TextExtractOptions;

public class NestedPartHandler extends MessageHandler {
    private final DocumentCollector collector;

    public NestedPartHandler(
        final DocumentCollector collector,
        final MailMetaInfo meta,
        final TextExtractOptions options)
    {
        super(meta.dropContentTypeAndCharset(), options);
        this.collector = collector;
    }

    @Override
    protected DocumentCollector collector() {
        return collector;
    }

    @Override
    public void endMessage() throws MimeException {
        super.endMessage();
        meta.counter().popPart();
    }
}

